﻿import csv
import json
from pathlib import Path
rows = []
with open('pipeline_claim/document_index.csv', newline='', encoding='utf-8') as f:
    reader = csv.DictReader(f)
    for row in reader:
        doc_id = row['doc_id'].strip()
        number = int(doc_id.replace('DOC', ''))
        path = row['path'].strip()
        if not path:
            continue
        stem = Path(path).stem
        friendly = stem.replace('_', ' ').replace('-', ' ')
        friendly = ' '.join(part.capitalize() for part in friendly.split())
        summary = row['notes'].strip() or friendly
        if len(summary) > 80:
            summary = summary[:77] + '...'
        display = friendly if len(friendly) <= 60 else friendly[:57] + '...'
        doc_type = row['doc_type'].strip().lower() or Path(path).suffix.lstrip('.')
        rows.append({
            'id': doc_id,
            'number': number,
            'path': '../' + path,
            'type': doc_type,
            'summary': summary,
            'label': f"Exhibit {number} - {display}",
        })
rows.sort(key=lambda r: r['number'])
print(json.dumps(rows, indent=2))
