# Claim Evidence Index + Rubric (Tom Ronnkvist)

Disclaimer: I’m not a lawyer and this is not legal advice. This is an organized evidence index and a neutral rubric you can review/edit before filing or presenting in court.


## Statement of Facts (Evidence-Based)
- 2024-03-21: Industrial add-in card purchased (order + receipts). (DOC09 p1; DOC12 p1; DOC17 p1)
- 2024-05-16: Quote for Pentium II tower + data transfer/integration for $689; Tom accepts. (DOC04 p1)
- 2024-05-20 to 2024-05-23: Pentium II system ordered and delivered (tracking 274924287408). (DOC10 p2; DOC11 p2)
- 2024-06-17: Update sent to Tom; adapters were ordered; no new tower was being ordered. (DOC20 p1; DOC13 p1-2)
- 2024-06-28 to 2024-07-09: Kyle requests ISA card details; Tom indicates he is working with MTI and will follow up. (DOC03 p1-2; DOC05 p1-2; DOC06 p1-2)
- 2024-09-12: Tech time + IDE hard drive replacement billed. (DOC19 p1)
- 2025-04-01: Tom asks for a plan to resolve the computer purchase. (DOC01 p3; DOC14 p3)
- 2025-04-23: Tom demands refund and threatens filing. (DOC01 p1; DOC14 p1)
- 2025-04-24: Jose responds, offers shipment, and cites custom order/labor policy; posted policy photo provided. (DOC02 p1-7; DOC21 p1)
- 2025-05-28: Defendant's answer provided to JP Precinct #1. (DOC49 p1)

## Document index (labeled)
- DOC01 – email communications/asking for refund in April months after I received last contact - we have been waiting for his replies and in custodianship of his PC and Adapters all this time.pdf (3 pages)
- DOC02 – email communications/Jose attempting to clarify and understand the situation.pdf (7 pages)
- DOC03 – email communications/kyle asking for clarification on details.pdf (2 pages)
- DOC04 – email communications/scope of work email.pdf (1 page)
- DOC05 – email communications/we are waiting email from Tom confirming that we are still waiting - last message I ever received via email from Tom until his recent threats for legal action.pdf (2 pages)
- DOC06 – Kyle requesting updated information for our virtualization attempt.pdf (2 pages)
- DOC07 – Kyle's original request for Tom's backup tower.pdf (1 page)
- DOC08 – Kyle's original request for Tom's replacement controller card and my response.pdf (1 page)
- DOC09 – shipping and tracking confirmations/ebay purchase of industrial add on card.pdf (1 page)
- DOC10 – shipping and tracking confirmations/ebay vendor confirmation for pentium II.pdf (3 pages)
- DOC11 – shipping and tracking confirmations/fedex tracking detail for the pentium 2 pc.pdf (3 pages)
- DOC12 – shipping and tracking confirmations/industrial add on card purchase - Tom's first hardware purchase at NPC.pdf (2 pages)
- DOC13 – shipping and tracking confirmations/USB to ISA adapter purchase for Tom.pdf (3 pages)
- DOC14 – Tom making legal threats even after Kyle promised delivery after he settles up his labor balance.pdf (3 pages)
- DOC15 – Tom's Payment Receipts/on-site testing of the welder control PC round 1 - #1238.pdf (2 pages)
- DOC16 – Tom's Payment Receipts/on-site testing of the welder control PC round 2 - verified software functionality problem - #1300.pdf (2 pages)
- DOC17 – Tom's Payment Receipts/payment for original industrial add on card - #1129.pdf (1 page)
- DOC18 – Tom's Payment Receipts/Tom paying for his backup tower and physical integration of his cards and hard disk to this system - #1311.pdf (2 pages)
- DOC19 – Tom's Payment Receipts/Tom returns to our shop to have us replace the hard disk on his failing controller system - #1650.pdf (3 pages)
- DOC20 – Tom's update request and my clarification.pdf (2 pages)
- DOC21 – policies on front desk.jpg (1 page)
  
Supplemental documents (DOC22+): additional DOCX summaries, policy statement, and pleadings were added and are listed in `document_index.csv` and the HTML index.

## Key facts summary (with citations to docs/pages)
- Scope/price quote: May 16, 2024 email from Kyle offering a machine with required expansion slots for $689 (includes transfer of hard drive data and expansion cards). Tom replies “Sounds good. I’ll bring the computer.” (DOC04 p1)
- Pentium II procurement confirmation: eBay order/shipping confirmation for the Pentium II system with tracking number 274924287408 (DOC10 p2). FedEx tracking shows delivery to Alice, TX on 5/23/24 at 12:01 PM, 39 lbs, direct signature required (DOC11 p2).
- USB-to-ISA adapter purchase: ARSTech order confirmation on 06/17/2024, total paid $278.85 (DOC13 p1–p2). Jose’s June 17, 2024 email says adapters were ordered and shipping confirmation was pending (DOC20 p1).
- Industrial add-on card purchase: eBay order for Industrial Computer Source add-in card placed/paid 3/21/2024, order total $84.95 (DOC09 p1). POS receipt shows Industrial Computer Source add-in card paid $216.00 with tax (DOC17 p1) and a detailed Zettle receipt with same total and date (DOC12 p1).
- Service labor paid: Tech time receipts for 0.75 hr ($112.50) on 4/24/2024 (DOC15 p1), 3 hr ($450.00) on 5/15/2024 (DOC16 p1), and tech time + IDE HDD $194.00 on 9/12/2024 (DOC19 p1).
- Customer requests and technical info: Kyle requests ISA card details on 6/28/2024; Tom replies 7/2/2024 that he’s still working with MTI and will follow up (DOC03 p1–p2). July 9, 2024 follow-up indicates Tom traveling and will call (DOC06 p1–p2; DOC05 p1–p2).
- April 2025 dispute/threats: Tom emails requesting a plan and refund and mentions a $254 filing fee and intent to proceed with legal action (DOC01 p1; DOC14 p1). Jose’s April 24, 2025 response states the Pentium II system and adapters are available for delivery, says Tom removed ISA cards, and asserts custom orders/labor are non-refundable per store policy (DOC02 p1–p7).
- Store policy photo: Photo of posted policy at the front desk. (DOC21 p1)

## Timeline (curated)
- 2024-03-18: Tom brings the ISA-based welder controller PC to NPC; the system is evaluated and a controller card failure is identified. (DOC24)
- 2024-03-21: Payment for replacement industrial ISA add-in card and integration. (DOC24; DOC17 p1; DOC12 p1)
- 2024-03-28: Replacement card integration completed; Tom retrieves the PC. (DOC24)
- 2024-04-24: On-site visit (0.75 hr) for testing; $112.50 charge. (DOC24; DOC15 p1)
- 2024-05-15: On-site visit (3 hr) with MTI technician; $450.00 charge. (DOC24; DOC16 p1)
- 2024-05-16: Quote for refurbished Pentium II system with ISA slots. (DOC24; DOC04 p1)
- 2024-05-20: Payment for refurbished PC and integration. (DOC24; DOC18 p1)
- 2024-05-21: eBay purchase confirmation for Pentium II tower. (DOC24; DOC10 p2)
- 2024-05-23: FedEx tracking shows shipment/delivery of the tower. (DOC24; DOC11 p2)
- 2024-06-17: Jose clarifies no new system was being ordered; USB-to-ISA adapters purchased. (DOC24; DOC13 p1-2; DOC20 p1)
- 2024-06-28: Kyle requests ISA card details for virtualization attempt. (DOC24; DOC38 p1)
- 2024-07-09: Tom acknowledges the message and indicates follow-up. (DOC24; DOC46 p1)
- 2024-07 (approx.): Tom retrieves his original PC and ISA cards from NPC. (DOC24)
- 2024-09: Tom returns with a failed hard drive; hardware swap performed; $194.00 charge. (DOC24; DOC19 p1)
- 2025-05: Document B states a small claims suit was filed. (DOC24)

## Rubric for your claim/defense (evidence checklist)
Use this as a neutral checklist. You can mark which side each point supports and which documents you will attach.

1) Agreement / scope of work
- Quote and acceptance for Pentium II system and data transfer/integration ($689). (DOC04 p1)
- Internal request to source Pentium II hardware for Tom. (DOC07 p1)

2) Payments / consideration
- Receipt for Pentium II PC ($678 total, receipt #1311). (DOC18 p1)
- Receipt for industrial add-in card ($216 total, receipt #1129). (DOC17 p1)
- Additional labor receipts (tech time and parts). (DOC15 p1; DOC16 p1; DOC19 p1)

3) Procurement / fulfillment steps
- eBay vendor confirmation for Pentium II system + tracking number. (DOC10 p2)
- FedEx tracking shows delivery with weight/dimensions (supports that a PC was shipped). (DOC11 p2)
- USB-to-ISA adapter order placed. (DOC13 p1–p2)

4) Communications and progress
- June–July 2024 communications seeking ISA card info and indicating ongoing troubleshooting. (DOC03 p1–p2; DOC05 p1–p2; DOC06 p1–p2)
- June 17, 2024 update to Tom about adapter order (and “not ordering a new tower” clarification). (DOC20 p1)

5) Delivery/availability of hardware
- Jose’s April 24, 2025 email states Pentium II system and adapters are ready and offers to ship at no cost. (DOC02 p1)
- FedEx tracking delivery details can be used to show arrival of the Pentium II system. (DOC11 p2)

6) Dispute/claim posture
- Tom’s refund demand and legal threat; mentions $254 filing fee. (DOC01 p1; DOC14 p1)
- Jose’s response disputing refund entitlement and referencing custom order/labor policy. (DOC02 p3–p7)

7) Damages / amounts (if you’re itemizing costs or offsets)
- Hardware receipts and payments: Pentium II ($678), add-in card ($216), USB-to-ISA adapters ($278.85). (DOC18 p1; DOC17 p1; DOC13 p2)
- Labor receipts: $112.50, $450.00, $194.00. (DOC15 p1; DOC16 p1; DOC19 p1)

## Gaps / items to gather before Feb 12, 2026
- Refund policy photo is now provided (posted policy at front desk). (DOC21 p1)
- DOC02 references a posted refund policy; no additional policy document identified beyond the posted photo. (DOC02 p3)
- Itemized labor logs or internal timesheets referenced in DOC02. (DOC02 p3, p5)
- Evidence of Tom’s pickup/visit where ISA cards were retrieved (work order, logs, or witness statement). (DOC02 p3, p5–p7)
- Any shipment/offer documentation for delivering the Pentium II system or adapters after 5/23/24. (DOC02 p1, p5–p7)

## Notes on duplicates / overlap
- DOC01 and DOC14 contain the same April 23, 2025 refund/filing threat email; DOC01 appears to be a forwarded copy.
- DOC05 and DOC06 are effectively the same July 2024 ISA-card-information thread.
- DOC12 and DOC17 both reference receipt #1129 for the add-in card; DOC12 is the Zettle email receipt format, DOC17 is a POS-style receipt.

---
Prepared for review on January 23, 2026. Hearing date noted by user: February 12, 2026.
