from pathlib import Path
import zipfile
import html

path = Path(r'd:\kreuzberg\pipeline_claim\DOCUMENT F_ BURDEN RUBRIC AND EXHIBITS OVERVIEW (UPDATED).docx')

lines = [
    'DOCUMENT F: BURDEN RUBRIC AND EXHIBIT INDEX (UPDATED)',
    'This rubric summarizes the core points and the evidence currently in the packet. References use DOC IDs from the exhibit list.',
    '',
    '1) Agreement / scope of work',
    'Burden: Show the agreed scope (Pentium II system + data transfer/integration).',
    'Evidence: DOC04; DOC07.',
    '',
    '2) Payments / consideration',
    'Burden: Show payments made for hardware and labor.',
    'Evidence: DOC18; DOC17; DOC15; DOC16; DOC19.',
    '',
    '3) Procurement / fulfillment steps',
    'Burden: Show the replacement system and adapters were sourced and delivered or made available.',
    'Evidence: DOC10; DOC11; DOC13; DOC02.',
    '',
    '4) Communications and progress',
    'Burden: Show ongoing requests for ISA card details and updates during troubleshooting.',
    'Evidence: DOC03; DOC05; DOC06; DOC20; DOC38.',
    '',
    '5) Refund policy / custom order position',
    'Burden: Show custom order and labor refund restrictions and the posted policy.',
    'Evidence: DOC02; DOC21.',
    '',
    '6) Dispute posture / filings',
    'Burden: Show refund demand, threats, and the filed answer/counterclaim response.',
    'Evidence: DOC01; DOC14; DOC49; DOC54.',
    '',
    'EXHIBIT INDEX (DOC IDs)',
    'DOC01 - Email communications requesting refund (April 2025).',
    'DOC02 - Jose response and policy references.',
    'DOC03 - Kyle requests ISA card details.',
    'DOC04 - Scope/quote email.',
    'DOC05 - Waiting for Tom confirmation (July 2024).',
    'DOC06 - Follow-up request for ISA info.',
    'DOC07 - Request for backup tower.',
    'DOC08 - Request for replacement controller card.',
    'DOC09 - eBay purchase of industrial add-on card.',
    'DOC10 - eBay vendor confirmation for Pentium II.',
    'DOC11 - FedEx tracking detail for Pentium II.',
    'DOC12 - Industrial add-on card receipt (email).',
    'DOC13 - USB-to-ISA adapter purchase.',
    'DOC14 - Legal threats after delivery offer.',
    'DOC15 - On-site testing receipt #1238.',
    'DOC16 - On-site testing receipt #1300.',
    'DOC17 - Add-on card payment receipt #1129.',
    'DOC18 - Pentium II payment receipt #1311.',
    'DOC19 - IDE HDD replacement receipt #1650.',
    'DOC20 - Update request and clarification.',
    'DOC21 - Photo of posted policy.',
    'DOC23 - Document A: Plain Language Summary (DOCX).',
    'DOC24 - Document B: Timeline (DOCX).',
    'DOC25 - Document C: Receipts and Payments (DOCX).',
    'DOC26 - Document E: Technical Challenges (DOCX).',
    'DOC27 - Document F: This rubric (DOCX).',
    'DOC28 - Document G: Work Performed Evidence (DOCX).',
    'DOC29 - Document H: Contradictions (DOCX).',
    'DOC30 - Document I: Statement of Good Faith (DOCX).',
    "DOC31 - Jay's Answer to Tom's Counterclaim Defense (DOCX).",
    'DOC32 - Jose clarifying no new tower (DOCX).',
    'DOC33 - Jose clarifying Pentium II (DOCX).',
    'DOC34 - Jose confirming store policies (DOCX).',
    'DOC35 - Jose offering to ship parts (DOCX).',
    'DOC36 - Jose seeking clarification after threats (DOCX).',
    "DOC37 - Jose's final resolution offer (DOCX).",
    'DOC38 - Kyle requesting information (DOCX).',
    'DOC39 - Tech labor summary (DOCX).',
    'DOC40 - Timeline of Events: Tom R (DOCX).',
    'DOC41 - Tom accepting virtualization path (DOCX).',
    'DOC42 - Tom accepting virtualization solution (DOCX).',
    'DOC43 - Tom getting project update (DOCX).',
    'DOC44 - Tom indicates still working with MTI (DOCX).',
    'DOC45 - Tom making legal threats (DOCX).',
    'DOC46 - Tom responding to information request (DOCX).',
    'DOC47 - Tom claiming he never engaged additional work (DOCX).',
    'DOC48 - Tom seems confused (DOCX).',
    "DOC49 - Tom's Answer provided to JP Precinct #1 (DOCX).",
    "DOC50 - Tom's sudden reversal (DOCX).",
    "DOC51 - Tom's continued threats (DOCX).",
    'DOC53 - Policies on front desk (image).',
    "DOC54 - Defendant's Answer (PDF, OCR).",
    'DOC55 - Labor Summary for Project Welder Control System (PDF, OCR).',
    'DOC56 - Answer doc (PDF, OCR).',
    'DOC57 - eBay (PDF, OCR).',
    'DOC58 - FedEx (PDF, OCR).',
    'DOC59 - Testimony questionnaire (PDF, OCR).',
]

paras = []
for line in lines:
    if line == '':
        paras.append('<w:p/>')
        continue
    safe = html.escape(line)
    paras.append(f'<w:p><w:r><w:t>{safe}</w:t></w:r></w:p>')

body = '\n'.join(paras)

xml = f'''<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<w:document xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main">
  <w:body>
{body}
    <w:sectPr>
      <w:pgSz w:w="12240" w:h="15840"/>
      <w:pgMar w:top="1440" w:right="1440" w:bottom="1440" w:left="1440" w:header="720" w:footer="720" w:gutter="0"/>
    </w:sectPr>
  </w:body>
</w:document>
'''

source = Path(r'd:\kreuzberg\pipeline_claim\DOCUMENT F_ BURDEN RUBRIC AND EXHIBITS OVERVIEW.docx')
if source.exists():
    with zipfile.ZipFile(source, 'r') as zin:
        tmp_path = path.with_suffix('.tmp.docx')
        with zipfile.ZipFile(tmp_path, 'w') as zout:
            for item in zin.infolist():
                if item.filename == 'word/document.xml':
                    zout.writestr(item, xml)
                else:
                    zout.writestr(item, zin.read(item.filename))
    path.unlink(missing_ok=True)
    tmp_path.rename(path)
else:
    with zipfile.ZipFile(path, 'w') as zout:
        zout.writestr('[Content_Types].xml', '<?xml version="1.0" encoding="UTF-8"?>')
        zout.writestr('word/document.xml', xml)

print('updated Document F (UPDATED) docx')
