from pathlib import Path

path = Path(r'd:\kreuzberg\pipeline_claim\styles.css')
text = path.read_text(encoding='utf-8', errors='replace')

if '.doc-back-inline' not in text:
    text += '''

.doc-back-inline {
  margin-left: 8px;
  background: #e2e8f0;
  border: 1px solid #cbd5e1;
  color: #1f2937;
  font-size: 0.82rem;
  padding: 6px 10px;
  border-radius: 8px;
  cursor: pointer;
}

.doc-back-inline:hover {
  background: #dbe5f0;
}

.docx-inline {
  border: 1px solid #e5e7eb;
  border-radius: 8px;
  background: #ffffff;
  padding: 10px;
  max-height: 380px;
  overflow: auto;
  margin-top: 10px;
}

.docx-inline pre {
  white-space: pre-wrap;
  font-family: "Georgia", "Times New Roman", serif;
  font-size: 0.96rem;
  line-height: 1.5;
}
'''
    path.write_text(text, encoding='utf-8')
    print('added styles for inline back and docx embed')
else:
    print('doc-back-inline styles already present')
