from pathlib import Path

path = Path(r'd:\kreuzberg\pipeline_claim\styles.css')
text = path.read_text(encoding='utf-8', errors='replace')
if '.burden-grid' not in text:
    text += '''

.burden-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
  gap: 16px;
  margin-top: 16px;
}

.burden-grid article {
  border: 1px solid #cbd5e1;
  border-radius: 10px;
  padding: 12px 14px;
  background: #fff;
  box-shadow: 0 8px 24px rgba(15, 23, 42, 0.08);
}

.burden-grid h3 {
  margin-top: 0;
  color: #1f4b7a;
}

.burden-grid .cite a {
  color: #1f3b5f;
}

.burden-footnote {
  margin-top: 18px;
  font-size: 0.95rem;
}

.burden-footnote .doc-link {
  display: inline-flex;
  align-items: center;
  justify-content: center;
}
'''
    path.write_text(text, encoding='utf-8')
    print('added Burden Rubric styles')
else:
    print('burden styles already present')
