from pathlib import Path
import re
path = Path(r'd:\kreuzberg\pipeline_claim\index.html')
text = path.read_text(encoding='utf-8', errors='replace')
start = text.find('<script>')
end = text.find('</script>', start)
if start == -1 or end == -1:
    raise SystemExit('script block not found')
new_script = '''<script>
(function () {
  const modal = document.getElementById('doc-modal');
  const modalBody = document.getElementById('modal-body');
  const modalTitle = document.getElementById('modal-title');
  let lastScrollY = 0;

  function openModal(title, contentHtml) {
    lastScrollY = window.scrollY || 0;
    modalTitle.textContent = title || 'Document';
    modalBody.innerHTML = contentHtml || '<p>No preview available.</p>';
    modal.setAttribute('aria-hidden', 'false');
    document.body.classList.add('modal-open');
  }

  function closeModal() {
    modal.setAttribute('aria-hidden', 'true');
    modalBody.innerHTML = '';
    document.body.classList.remove('modal-open');
    window.scrollTo({ top: lastScrollY, behavior: 'auto' });
  }

  document.addEventListener('click', function (e) {
    const close = e.target.closest('[data-close="true"]');
    const backInline = e.target.closest('.doc-back-inline');
    if (backInline) {
      e.preventDefault();
      window.scrollTo({ top: lastScrollY, behavior: 'auto' });
      return;
    }

    const back = e.target.closest('[data-back="true"]');
    if (back) {
      e.preventDefault();
      closeModal();
      return;
    }
    if (close) {
      e.preventDefault();
      closeModal();
      return;
    }

    const link = e.target.closest('a.doc-open');
    if (!link) return;

    const card = link.closest('.doc-card');
    if (!card) return;

    e.preventDefault();
    const h3 = card.querySelector('h3');
    const title = h3 ? h3.textContent : 'Document';
    const embed = card.querySelector('.doc-embed');
    let contentHtml = embed ? embed.innerHTML : '<p>No preview available.</p>';

    const linkTarget = link.getAttribute('data-file') || '';
    let fileParam = '';
    if (linkTarget.includes('doc_viewer.html?file=')) {
      fileParam = linkTarget.split('doc_viewer.html?file=')[1];
      if (fileParam.includes('&page=')) {
        fileParam = fileParam.split('&page=')[0];
      }
    }

    if (fileParam) {
      const ext = fileParam.split('.').pop().toLowerCase();
      if (ext === 'pdf') {
        contentHtml = `<object data="${fileParam}" type="application/pdf" width="100%" height="720"></object>`;
      } else if (['jpg','jpeg','png','gif','webp'].includes(ext)) {
        contentHtml = `<img src="${fileParam}" alt="Document image" />`;
      }
    }

    const docx = card.querySelector('.docx-content');
    if (docx) {
      contentHtml = docx.innerHTML;
    }

    openModal(title, contentHtml);
  });

  document.addEventListener('keydown', function (e) {
    if (e.key === 'Escape' && modal.getAttribute('aria-hidden') === 'false') {
      closeModal();
    }
  });
})();
</script>'''
text = text[:start] + new_script + text[end+9:]
path.write_text(text, encoding='utf-8')
print('replaced modal script block')
