import re
from pathlib import Path

path = Path(r'd:\kreuzberg\pipeline_claim\index.html')
text = path.read_text(encoding='utf-8', errors='replace')

# Add email class to doc-cards with "Email Thread" in title

def add_class(match):
    opening = match.group(1)
    content = match.group(2)
    if 'Email Thread' in content:
        if 'doc-card email' in opening:
            return match.group(0)
        opening = opening.replace('doc-card"', 'doc-card email"')
        return opening + content + match.group(3)
    return match.group(0)

pattern = re.compile(r'(<section class="doc-card"[^>]*>)([\s\S]*?)(</section>)', re.MULTILINE)
text = pattern.sub(add_class, text)

path.write_text(text, encoding='utf-8')
print('added email class to email thread exhibits')
