from pathlib import Path

path = Path(r'd:\kreuzberg\pipeline_claim\styles.css')
text = path.read_text(encoding='utf-8', errors='replace')

if '.doc-card.email' not in text:
    text += '''

.doc-card.email {
  border-left: 6px solid #1f4b7a;
  background: #fbfdff;
}

.doc-card.email .doc-meta {
  background: #f1f6fb;
  border-bottom: 1px solid #d8e2ee;
  padding: 14px 16px;
}

.doc-card.email .doc-meta h3 {
  font-family: "Georgia", "Times New Roman", serif;
}

.doc-card.email .doc-summary {
  color: #334155;
}

.doc-card.email .doc-embed {
  background: #ffffff;
  border-top: 1px dashed #cbd5e1;
}

.doc-card.email .docx-inline,
.doc-card.email object {
  border: 1px solid #d6e0ec;
  box-shadow: inset 0 0 0 1px #eef3f8;
}
'''
    path.write_text(text, encoding='utf-8')
    print('added email styling')
else:
    print('email styling already present')
