#!/bin/sh
set -eu
mkdir -p /data/_analysis_kreuzberg
find /data -type f \( -iname "*.pdf" -o -iname "*.docx" -o -iname "*.jpg" -o -iname "*.jpeg" -o -iname "*.png" \) -not -path "/data/_analysis_kreuzberg/*" -print |   while IFS= read -r f; do
    base=$(printf "%s" "$f" | sed "s#^/data/##; s#[/ ]#_#g")
    out="/data/_analysis_kreuzberg/${base}.json"
    kreuzberg extract "$f" --format json > "$out"
  done
