from pathlib import Path

path = Path(r'd:\kreuzberg\pipeline_claim\styles.css')
text = path.read_text(encoding='utf-8', errors='replace')

if '.theme-toggle' not in text:
    text += '''

.theme-toggle {
  position: absolute;
  top: 14px;
  right: 14px;
  background: #e2e8f0;
  border: 1px solid #cbd5e1;
  color: #1f2937;
  font-size: 0.85rem;
  padding: 6px 10px;
  border-radius: 999px;
  cursor: pointer;
}

.theme-toggle:hover {
  background: #dbe5f0;
}

[data-theme="dark"] {
  color-scheme: dark;
}

[data-theme="dark"] body {
  background: linear-gradient(180deg, #0b1220 0%, #0f172a 40%, #111827 100%);
  color: #e2e8f0;
}

[data-theme="dark"] .hero {
  background: linear-gradient(180deg, #0f172a 0%, #111827 100%);
  border-bottom: 2px solid #334155;
}

[data-theme="dark"] .subtitle,
[data-theme="dark"] .doc-summary {
  color: #cbd5f5;
}

[data-theme="dark"] .doc-card {
  background: #0f172a;
  border-color: #334155;
  box-shadow: 0 6px 18px rgba(0,0,0,0.35);
}

[data-theme="dark"] .toc-section h2,
[data-theme="dark"] .rubric h2,
[data-theme="dark"] .docs > h2 {
  color: #93c5fd;
  border-color: #334155;
}

[data-theme="dark"] .doc-link,
[data-theme="dark"] .cite {
  color: #93c5fd;
}

[data-theme="dark"] .docx-inline {
  background: #0b1220;
  border-color: #1f2937;
}

[data-theme="dark"] .modal-dialog {
  background: #0f172a;
  color: #e2e8f0;
}

[data-theme="dark"] .modal-close,
[data-theme="dark"] .modal-back,
[data-theme="dark"] .doc-back-inline {
  background: #1f2937;
  border-color: #334155;
  color: #e2e8f0;
}

[data-theme="dark"] .theme-toggle {
  background: #1f2937;
  border-color: #334155;
  color: #e2e8f0;
}
'''
    path.write_text(text, encoding='utf-8')
    print('added dark mode styles')
else:
    print('theme-toggle styles already present')
