﻿from pathlib import Path
path=Path('pipeline_claim/index.html')
text=path.read_text(encoding='utf-8')
old="""    const cards = Array.from(document.querySelectorAll('.doc-card'));
    const index = cards.map((card) => {
      const h3 = card.querySelector('h3');
      const summary = card.querySelector('.doc-summary');
      const rawTitle = h3 ? h3.textContent.trim() : '';
      const docNumberMatch = rawTitle.match(/Exhibit\\s+(\\d+)/i);
      const docNumber = docNumberMatch ? docNumberMatch[1] : '';
      const desc = rawTitle.split(' - ')[1] || rawTitle;
      const searchText = [rawTitle, summary ? summary.textContent : ''].join(' ').toLowerCase();
      return {
        id: card.id,
        title: rawTitle,
        description: desc,
        summary: summary ? summary.textContent.trim() : '',
        docNumber,
        searchText,
      };
    });
"""
new="""    const cards = Array.from(document.querySelectorAll('.doc-card'));
    const index = cards.map((card) => {
      const h3 = card.querySelector('h3');
      const summary = card.querySelector('.doc-summary');
      const rawTitle = h3 ? h3.textContent.trim() : '';
      const docNumberMatch = rawTitle.match(/Exhibit\\s+(\\d+)/i);
      const docNumber = docNumberMatch ? docNumberMatch[1] : '';
      const desc = rawTitle.split(' - ')[1] || rawTitle;
      const searchText = [rawTitle, summary ? summary.textContent : ''].join(' ').toLowerCase();
      const exhibitLabel = docNumber ? `Exhibit ${docNumber}${desc ? ` - ${desc}` : ''}` : rawTitle;
      return {
        id: card.id,
        title: rawTitle,
        description: desc,
        summary: summary ? summary.textContent.trim() : '',
        docNumber,
        exhibitLabel,
        searchText,
      };
    });
"""
if old not in text:
    raise SystemExit('old snippet missing')
text=text.replace(old,new,1)
path.write_text(text,encoding='utf-8')
