import os

nav = '''<nav class="doc-nav">
  <a href="../index.html#section-issues">Issues Presented</a>
  <a href="../index.html#section-facts">Statement of Facts</a>
  <a href="../index.html#section-timeline">Timeline</a>
  <a href="../index.html#section-burden">Burden Rubric</a>
  <a href="../index.html#section-exhibits">Exhibit Library</a>
  <a href="../doc_viewer.html">← Documents</a>
</nav>'''

script = '''<script>
(function() {
  const stored = localStorage.getItem('theme');
  if (stored === 'dark') {
    document.documentElement.setAttribute('data-theme', 'dark');
    document.body.setAttribute('data-theme', 'dark');
  }
})();
</script>'''

html_dir = "pipeline_claim/html"

for f in os.listdir(html_dir):
    if f.endswith(".html"):
        path = os.path.join(html_dir, f)
        with open(path, 'r', encoding='utf-8') as fp:
            content = fp.read()
        
        # Remove ALL navs and scripts
        while '<nav class="doc-nav">' in content:
            content = content.split('<nav class="doc-nav">')[0] + content.split('</nav>')[1].split('</script>')[-1]
        
        # Remove all </script> at end
        content = content.replace('</script>', '').strip()
        
        # Add nav and script before </body>
        content = content.rstrip() + nav + script + '</body></html>'
        
        with open(path, 'w', encoding='utf-8') as fp:
            fp.write(content)
        print(f"Fixed {f}")
