import os
import re

nav_html = """<nav class="doc-nav">
  <a href="../index.html#section-issues">Issues Presented</a>
  <a href="../index.html#section-facts">Statement of Facts</a>
  <a href="../index.html#section-timeline">Timeline</a>
  <a href="../index.html#section-burden">Burden Rubric</a>
  <a href="../index.html#section-exhibits">Exhibit Library</a>
  <a href="../doc_viewer.html">← Documents</a>
</nav>"""

dark_script = """<script>
(function() {
  const stored = localStorage.getItem('theme');
  if (stored === 'dark') {
    document.documentElement.setAttribute('data-theme', 'dark');
    document.body.setAttribute('data-theme', 'dark');
  }
})();
</script>"""

html_dir = "pipeline_claim/html"

for filename in os.listdir(html_dir):
    if filename.endswith(".html"):
        filepath = os.path.join(html_dir, filename)
        with open(filepath, "r", encoding="utf-8") as f:
            content = f.read()
        
        # Remove duplicate navs and scripts before </body>
        content = re.sub(r'<nav class="doc-nav">.*?</nav>\s*<script>.*?</script>\s*', '', content, flags=re.DOTALL)
        
        # Ensure only one nav and one script before </body>
        if "</body>" in content and 'class="doc-nav"' in content:
            content = re.sub(r'\s*<nav class="doc-nav">.*?</nav>\s*<script>.*?</script>\s*', 
                          f"{nav_html}{dark_script}", 
                          content, 
                          flags=re.DOTALL)
        
        # Ensure it ends with the nav + script + </body>
        content = re.sub(r'\s*</body>\s*', f"{nav_html}{dark_script}</body>", content)
        
        with open(filepath, "w", encoding="utf-8") as f:
            f.write(content)
        print(f"Cleaned {filename}")

print("Done!")
