﻿$root = Join-Path (Get-Location) 'claim'
$target = Join-Path (Get-Location) 'pipeline_claim\original_documents.html'

function Get-TreeHtml($path, $base) {
  $items = Get-ChildItem -LiteralPath $path | Sort-Object { -not $_.PSIsContainer }, Name
  $out = @()
  $out += '<ul>'
  foreach ($item in $items) {
    if ($item.PSIsContainer) {
      $out += "<li><strong>$($item.Name)</strong>"
      $out += Get-TreeHtml -path $item.FullName -base $base
      $out += '</li>'
    } else {
      $rel = Resolve-Path -LiteralPath $item.FullName | ForEach-Object { $_.Path.Substring($base.Length + 1) }
      $href = "..\claim\$rel" -replace '\\','/'
      $label = $item.Name.Replace('&','&amp;').Replace('<','&lt;').Replace('>','&gt;')
      $out += "<li><a href=`"$href`" target=`"_blank`" rel=`"noreferrer`">$label</a></li>"
    }
  }
  $out += '</ul>'
  return $out
}

$tree = Get-TreeHtml -path $root -base $root
@"
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Original Documents</title>
  <style>
    body { font-family: ui-monospace, SFMono-Regular, Menlo, Consolas, "Liberation Mono", monospace; background: #f6f7fb; color: #1f2937; margin: 24px; }
    h1 { font-size: 20px; margin: 0 0 12px; }
    p { margin: 0 0 16px; color: #4b5563; }
    ul { list-style: none; margin: 0 0 0 14px; padding: 0; }
    li { margin: 4px 0; }
    a { color: #1d4ed8; text-decoration: none; }
    a:hover { text-decoration: underline; }
    .legend { font-size: 12px; color: #6b7280; }
    .back { display: inline-block; margin-bottom: 12px; }
  </style>
</head>
<body>
  <a class="back" href="index.html">← Back to Packet</a>
  <h1>Original Documents (Claim Folder)</h1>
  <p>Classic file tree with direct links to the original files.</p>
  <div class="legend">Root: ..\claim</div>
  $([string]::Join("`n", $tree))
</body>
</html>
"@ | Set-Content -Path $target -Encoding UTF8
